# VoxelSite

AI-powered website builder. Describe your business, get a beautifully designed website. Self-hosted, single upload, no coding required.

## Quick Start

1. **Upload** the entire zip contents to your web server (`public_html` or document root)
2. **Open** `yourdomain.com/_studio/` in your browser — the installer starts automatically
3. **Follow** the wizard: requirements check → AI provider → admin account → site name
4. **Done** — start describing your website in plain language

Full documentation: **[voxelsite.com/docs](https://voxelsite.com/docs)**

## Requirements

- **PHP 8.2+** with extensions: `pdo_sqlite`, `openssl`, `json`, `curl`, `mbstring`, `gd`, `ZipArchive`
- **Any web server** — Apache, Nginx, LiteSpeed, etc. (`.htaccess` ships included for Apache; Nginx requires a one-time config for clean URLs — see [docs](https://voxelsite.com/docs/getting-started/installation))
- Writable directories: `_studio/data`, `_studio/preview`, `assets`

> **No command line needed.** No `composer install`, no `npm`, no SSH. Upload via FTP or your hosting file manager, open the URL, done.

## What's Included

- **AI Studio** — chat-driven interface to create and edit multi-page websites
- **Code Editor** — built-in Monaco editor with file explorer, multi-tab editing, create and delete files
- **Live Preview** — see every change before publishing
- **Undo/Redo** — full revision history with safe editing workflow
- **Snapshots** — save/restore entire site states
- **Asset Manager** — upload images, files, and fonts
- **Forms** — submission handling with email notifications
- **AEO** — built-in AI discoverability (`llms.txt`, schema, MCP endpoint)

## Supported AI Providers

- Anthropic Claude (recommended)
- OpenAI
- Google Gemini
- DeepSeek
- Any OpenAI-compatible endpoint

API keys are encrypted at rest. You bring your own key.

## Package Structure

```
/                   → Your live website (generated by AI)
/_studio/           → Admin Studio, installer, engine
/_partials/         → Shared site partials (header, footer, nav)
/assets/            → CSS, JS, images, fonts, data, forms
/_data/             → Form submissions and uploads (private)
/vendor/            → PHP dependencies (required — do not delete)
```

## Updating

Use the built-in updater: **Studio → Settings → Update → upload the latest `.zip`**

Your content, settings, and data are preserved automatically.

## Troubleshooting

| Problem | Fix |
|---|---|
| Root URL returns 403 | Normal before first publish. Go to `yourdomain.com/_studio/` instead |
| Installer says "Cannot reach server" | **Apache?** Enable `mod_rewrite` + `AllowOverride All`. **Any server?** Verify PHP 8.2+ is running and `.php` files are processed |
| Blank page / 500 error | Verify PHP 8.2+ is active and required extensions are installed |
| Permission errors | Make `_studio/data`, `_studio/preview`, `assets` writable (755 or 775) |
| Routes return 404 (Apache) | Enable `mod_rewrite` and `AllowOverride All` |
| Pages show homepage (Nginx) | Add clean URL rewriting to Nginx config. See [Installation → Nginx](https://voxelsite.com/docs/getting-started/installation) |
| AI not responding | Check your API key in Settings. Verify cURL and outbound HTTPS work |
| Upload fails (file size) | Increase `upload_max_filesize` and `post_max_size` in PHP settings |
| Generation produces only a few files, missing CSS/JS | PHP execution timeout is too low. Set `max_execution_time`, `request_terminate_timeout`, and `fastcgi_read_timeout` to at least 600. See [Server timeout configuration](https://voxelsite.com/docs/getting-started/requirements) |

## Security

- Studio is protected by login, session tokens, and CSRF checks
- Use HTTPS in production
- Keep regular backups of `_studio/data/`, `assets/`, and `_data/`
- Do not remove the shipped `.htaccess` files

## Support

Full documentation at **[voxelsite.com/docs](https://voxelsite.com/docs)**

For help, use the support channel provided with your purchase. Include:
- PHP version
- Hosting type
- Exact error message or screenshot

## License

Proprietary commercial script. See LICENSE file for terms.
