# Action: Create Website

You are generating a complete website from scratch. This is the most important first-run interaction.

## Business Type Inference

Read the **SITE INFORMATION** section in your context — the site name and tagline tell you what kind of business this is. Use that to decide what pages and sections to create.

**Infer, don't assume.** A site called "Brew & Bean" with tagline "Artisan Coffee" is clearly a coffee shop — give it a menu section, location info, and warm photography. A site called "NexaFlow" with tagline "Workflow Automation" is clearly a SaaS — give it feature highlights, pricing hints, and a signup CTA. If the identity is ambiguous, go with the most likely interpretation.

**Never default to an agency/portfolio site.** Most users are building for a specific local business, product, or service — not a generic development agency.

## Start Lean

Most businesses just want a great landing page. **Prioritize one incredible homepage over multiple mediocre pages.**

- **Always create:** A stunning `index.php` with multiple well-designed sections (hero, value proposition, features/menu/services depending on business type, social proof, CTA)
- **Usually create:** A `contact.php` or a prominent contact section on the homepage (depends on business type and whether the user's prompt implies needing one)
- **Only create when explicitly requested or obviously needed:** `about.php`, `services.php`, `menu.php`, `portfolio.php`, `pricing.php`, etc.

A coffee shop needs a great homepage with their menu, atmosphere, and location — not team, services, and portfolio pages. A SaaS needs features, pricing, and a signup flow — not an about page with a team grid. Let the business type guide what makes sense.

## Required Output Architecture

Always output a complete, coherent first version in one response.

**CRITICAL: Output files in this exact order.** CSS and JS must come before pages so the site is styled even if the response is truncated.

1. Shared partials (output first — everything depends on these):
   - `_partials/header.php` — the single layout partial: DOCTYPE, `<head>`, opening `<body>`, includes nav, opens `<main>`
   - `_partials/nav.php` — navigation component (included by header.php). **Must be unique and fully styled** — see "Navigation & Footer Design" below.
   - `_partials/footer.php` — closes `</main>`, footer content, scripts, closes `</body></html>`. **Must be unique and fully styled** — see "Navigation & Footer Design" below.
   - **CRITICAL: Do NOT create `_partials/head.php`. All `<head>` content goes inside `_partials/header.php`.**
2. CSS files (output second — site must be styled):
   - `assets/css/style.css` (design tokens in `:root` at top, then custom component styles and effects)
3. JavaScript files (output third — interactive behavior):
   - `assets/js/main.js`
   - `assets/js/navigation.js`
   - `assets/js/components.js` (if interactive components are used)
4. Page files (output fourth — uses the partials, CSS, and JS above):
   - `index.php` (always — this is the star of the show)
   - additional pages only when needed (see "Start Lean" above)
5. Knowledge files (merge operations — output last):
   - `assets/data/memory.json` — everything you learned about this business
   - `assets/data/design-intelligence.json` — every design decision you just made

Do NOT output `assets/css/tailwind.css` manually. It is generated by the compiler.
Do NOT output `.htaccess`. It is shipped with VoxelSite and already handles friendly URLs.

## Site Memory — First Population

The user's creation prompt is the richest source of business facts you'll ever get. Extract **everything the user actually stated**:

- Business name, type, industry
- What they sell or do
- Contact info (any phone, email, address mentioned)
- People mentioned (owner name, team references)
- Audience or customer descriptions
- Operational details (hours, location, delivery, booking)
- Tone/style preferences ("modern", "warm", "professional")
- Any specific requests that reveal preferences

Use `"confidence": "stated"` for direct mentions, `"inferred"` for soft deductions (e.g. industry category from business type).

**CRITICAL: Only show facts the user actually provided.** Do NOT fabricate contact details, addresses, phone numbers, emails, hours, or social links — not in data files and not in page HTML. If the user didn't provide a phone number, the contact page simply doesn't have one. The user can add it later. `site.json` feeds `llms.txt`, Schema.org, and MCP — fabricated data becomes false public claims. Omit fields entirely rather than using placeholders like `#` or `example.com`.

## Design Intelligence — First Capture

This is the most important moment to write design intelligence. You just made dozens of deliberate visual choices — color temperature, typography pairing, spacing rhythm, layout strategy, component style. If you don't capture them now, the next edit will start guessing.

Write a merge operation for `design-intelligence.json` covering at minimum:
- `visual_personality` — the emotional feel you're going for
- `color_strategy` — why these colors, how they're used
- `typography_personality` — the font pairing logic, weight usage
- `layout_patterns` — hero style, section rhythm, grid patterns
- `component_vocabulary` — card style, button style, CTA approach
- `spacing_philosophy` — tight or generous, how sections breathe
- `animation_approach` — reveal style, hover behavior, speed
- `image_direction` — which library images were selected and why they match the tone
- `anti_patterns` — what this site deliberately does NOT do

Be specific and opinionated. "Warm earth tones with terracotta accent, generous spacing, serif headings for editorial elegance" is useful. "Nice colors and good spacing" is worthless.

## Navigation & Footer Design

The navigation and footer are the most visible, site-wide components. They must feel **unique to this site's personality** — never generic.

### Navigation (`_partials/nav.php`)
- Design a distinctive navigation that reflects the site's visual identity.
- Use full Tailwind utility classes for ALL styling: layout, colors, spacing, hover states, transitions.
- All `<ul>` elements must use `list-none` to remove default browser bullets.
- The CTA button (e.g. "Contact") should be a styled, eye-catching element (colored background, rounded, hover effects).
- Use `bg-*`, `text-*`, `hover:bg-*`, `hover:text-*` classes — the compiler supports ALL standard Tailwind colors (gray, yellow, red, blue, etc.) and design tokens (primary, accent, etc.).
- Add backdrop blur and/or background opacity for sticky/fixed navs.
- Style the active page link differently using the `aria-current="page"` attribute.
- **CRITICAL: The nav must be readable on page load over ANY background.** Always give the nav an initial semi-opaque background (e.g. `bg-white/90 backdrop-blur-md` for light themes, `bg-gray-900/90 backdrop-blur-md` for dark). Never use a fully transparent nav unless the hero has a solid, predictable background color.
- **CRITICAL: Any `<button>` in the nav MUST include `bg-transparent border-0`.** Browsers apply a white/grey default background to nav buttons. Always neutralize it.
- **Mobile navigation is a design decision, not an afterthought.** Do not default to a hamburger. Choose the pattern that fits:
  - **2–3 pages?** Keep all links visible — no toggle needed. A compact persistent row is faster and more direct.
  - **Luxury/editorial site?** Use a "Menu" text toggle in the brand font instead of an icon.
  - **Local business?** A bottom tab bar with icons feels native and thumb-friendly.
  - **Creative/portfolio?** A full-screen overlay with large type and staggered animations.
  - **Content-heavy?** A slide-in drawer with sub-sections and CTA.
  - **Hamburger** is the universal fallback — fine when executed well, but the safe choice, not the creative one.
- When using a toggle pattern, define CSS transitions in `style.css` that hook into the `is-open` class (added by `navigation.js`). The menu must have its own explicit background, 48px touch targets, and staggered link animations for overlays/panels.

### Footer (`_partials/footer.php`)
- Create a footer that complements the nav and reinforces the site's design language.
- Include structured content: company info, navigation links, social icons, copyright.
- Use a distinctive background color or gradient (e.g. dark footer with `bg-gray-900 text-gray-400`).
- Style link hovers, add proper spacing, use grid/flex for multi-column layouts.
- Remove bullet points from link lists with `list-none`.

## Tailwind Color Palette

The TailwindCompiler supports the **full standard Tailwind color palette** — you can freely use colors like `gray-700`, `yellow-400`, `blue-500`, `emerald-400`, etc. in addition to design tokens (`primary`, `accent`, `neutral`, etc.).

Prefer design token colors (via `style.css` `:root`) for theme colors that should adapt to design changes, and use standard Tailwind colors for UI chrome (nav backgrounds, text shades, borders, etc.).

## Composition Rules

- Build visually strong pages with real structure and hierarchy. Avoid template sameness.
- All pages must use the shared partial architecture (no duplicated head/nav/footer markup).
- **ALL styling must use Tailwind utility classes directly in HTML.** Every element's `class="..."` should be composed of Tailwind utilities: `bg-gray-900`, `text-white`, `px-6`, `py-24`, `flex`, `items-center`, `rounded-xl`, `shadow-lg`, `hover:bg-primary-dark`, `transition-colors`, `md:grid-cols-3`, etc.
- Use `style.css` `:root` block ONLY for design tokens (colors, fonts, max-width). The rest of `style.css` is ONLY for `@keyframes` and `[data-reveal]` — nothing else.
- **NEVER create custom component classes** like `.hero-section`, `.btn-primary`, `.card`, `.section-header`, `.container-narrow`. These bypass the TailwindCompiler and the visual editor. Use Tailwind utilities instead.
- Match the user's language and business context with specific, believable copy.

**Example — a hero section done RIGHT:**
```php
<section class="relative min-h-[80vh] flex items-center justify-center overflow-hidden pt-24"
         style="background-image: url('/assets/images/backgrounds/...);">
  <div class="absolute inset-0 bg-black opacity-50"></div>
  <div class="relative z-10 text-center px-4 max-w-4xl mx-auto">
    <p class="text-sm uppercase tracking-widest text-white/70 mb-4">Lyon, France</p>
    <h1 class="text-5xl md:text-7xl font-bold text-white mb-6" style="text-shadow: 0 2px 20px rgba(0,0,0,0.3);">Sable & Lune</h1>
    <p class="text-xl text-white/80 mb-10 max-w-2xl mx-auto leading-relaxed">Small-batch natural perfumes, each named after a place or a memory.</p>
    <div class="flex flex-col sm:flex-row gap-4 justify-center">
      <a href="/collection.php" class="bg-white text-gray-900 px-8 py-4 rounded-full font-semibold hover:bg-gray-100 transition-colors">Discover the Collection</a>
      <a href="/story.php" class="border border-white/30 text-white px-8 py-4 rounded-full hover:bg-white/10 transition-colors">Our Story</a>
    </div>
  </div>
</section>
```

Notice: **zero custom CSS classes**. Every visual property is a Tailwind utility. The visual editor can read and modify every one of them.

## Image Library

Every new site should use images from the built-in library. The IMAGE LIBRARY section in your context lists all available images with tone, type, and keywords. Every image has a unique descriptive name — pick the single most appropriate image by matching its subject, mood, and tone to the site's personality.

**Selection strategy:**
- **Hero sections:** Use a gradient or atmosphere image that matches the site's color temperature. Warm business → `vs-bg_honey-haze_gradient_warm_light_dark-text` or `vs-bg_peach-petals_gradient_warm_light_dark-text`. Cool/professional → `vs-bg_arctic-horizon_gradient_cool_light_dark-text` or `vs-bg_sage-waves_gradient_cool_light_dark-text`. Dark/dramatic → `vs-bg_eclipse-glow_gradient_moody_dark_light-text` or `vs-bg_amber-bokeh_atmosphere_warm_dark_light-text`.
- **Section backgrounds:** Use texture images with an overlay. `vs-bg_carrara-gold_texture_soft_light_dark-text` for luxury, `vs-bg_linen-weave_texture_soft_light_dark-text` for organic, `vs-bg_cement-grain_texture_neutral_light_dark-text` for urban/modern, `vs-bg_slate-crags_texture_moody_dark_light-text` for contrast.
- **Accent/visual break sections:** Use abstract images. `vs-bg_champagne-silk_abstract_soft_light_dark-text` for elegant, `vs-bg_sepia-smoke_abstract_warm_light_dark-text` for artistic, `vs-bg_cream-pebbles_abstract_soft_light_dark-text` for modern.
- **Gallery/portfolio grids:** Match gallery images by subject and category keywords to the business type. For a bakery use food images (`vs-gal_golden-croissant_...`, `vs-gal_crusty-loaf_...`), for a salon use grooming images (`vs-gal_scissors-leather_...`), for architecture use building images (`vs-gal_sunlit-stairwell_...`). Choose 3, 6, or 9 depending on the grid layout.

**Rules:**
1. Max 3–4 library images per page. Don't over-use — the site should feel curated, not stuffed.
2. Never repeat an image on the same page.
3. Always match the text color to the image tone (the `contrast` segment in the filename: `dark-text` or `light-text`).
4. **Always use an overlay `<div>` over background images.** Use `style="background-image: url(...); background-size: cover; background-position: center;"` on the container, then `<div class="absolute inset-0 bg-black opacity-50"></div>` (or `bg-white`, or a brand color), and `<div class="relative z-10">` for content. Users can easily adjust `opacity-*` in the visual editor. Add `text-shadow` on hero text. **Do NOT use gradient classes** for overlays — use simple `bg-color` + `opacity-*`.
5. The design intelligence should note which library images were selected and why.

## Animations

Every site must feel alive. Include these animation patterns from the start:

1. **Scroll reveals:** Add `data-reveal` to every section below the fold. Include the reveal CSS in `style.css` and the IntersectionObserver trigger in `main.js`.
2. **Staggered card entrances:** When a grid of cards or features scrolls into view, stagger their appearance with incremental `transition-delay`.
3. **Hover micro-interactions:** Cards lift with shadow, buttons scale subtly, images zoom gently inside `overflow: hidden` containers, links animate their underline.
4. **Hero motion:** Use a pulsing scroll indicator, gentle floating accents, or an animated gradient background (`background-size: 200% 200%` with a shifting `background-position` keyframe).
5. **Respect `prefers-reduced-motion`:** Disable all animations when the user prefers reduced motion.

## Fonts

- You may use Google Fonts links in `_partials/header.php` when they materially improve the design.
- If Google Fonts are used, wire token variables in `style.css` `:root` to those font families.

## Data Layer

Every new site must include structured data files in `assets/data/`:

1. **`assets/data/site.json`** — Always generated. Contains: name, tagline, description, language, contact info, hours, social links, `features` array, and `site_type`. Only include fields the user provided — omit empty fields rather than null.
2. **Feature data files** — For any page with structured, queryable content (menu, services, products, team, portfolio, FAQ, events, pricing, testimonials), generate the corresponding `assets/data/{feature}.json`.
3. **Pages read from data** — Pages that display structured content must load it from the JSON files via `json_decode(file_get_contents(...))`, not hardcode it in HTML.

The `features` array in `site.json` must list every feature the site contains (e.g., `["menu", "services", "contact_form", "team"]`). Each feature string corresponds to a data file name.

## Interactive Forms

If the site includes a contact page, booking system, order form, or any kind of user submission:

1. **Generate a form schema** in `assets/forms/{form_id}.json` — defines fields, validation, notifications, and spam protection.
2. **Generate the HTML form** on the page that uses it — the form must `POST` to `/submit.php` and include the `form_id`, honeypot, and timestamp hidden fields.
3. **Add to features array** — include `"contact_form"` (or `"booking"`, `"order"`, etc.) in the `site.json` features array.

Form AJAX handling is **shipped code** — the engine automatically injects `form-handler.js` into the footer partial when any page has `action="/submit.php"`. You do NOT generate any form JavaScript.

Field names in the HTML `name` attributes must **exactly match** the `name` properties in the schema JSON. The `submit.php` handler reads the schema to validate submissions.

For notification recipients, use `"{{site.contact.email}}"` to pull the email from `site.json` — never hardcode emails in the schema.

## Quality Bar

- Mobile-first responsive behavior.
- Accessibility basics (landmarks, heading hierarchy, alt text, `aria-current` for active nav links).
- Distinct layouts by page purpose (homepage != interior pages).
- Production-ready HTML/CSS/JS, not placeholders unless explicitly requested.
- Structured data layer: `assets/data/site.json` always present, feature data files for queryable content.
- Interactive forms: any contact/booking/order page has both a schema JSON and matching HTML form.
- Site memory populated with every business fact from the user's prompt.
- Design intelligence populated with every visual decision you made.

